<?php

/**
 *
 * Plugin Name: EBN Core Plugsin
 * Version:     1.8
 * Description: EBN Core Plugin
 * Author:      Big IM Toolbox
 * Author URI:  http://bigimtoolbox.com
 */

if (!defined('ABSPATH')) {
    header('Status: 404 Not found');
    ?>Not found<?php
}

/**
 * Internal Mail
 */
class Mailbox
{

    function __construct()
    {

        if (is_admin() && $this->mail_enabled()) {

            add_action('admin_menu', array($this, 'admin_menu'));
            add_action('wp_ajax_mailbox-get_list', array($this, 'mailbox_list'));
            add_action('wp_ajax_mailbox-get_message', array($this, 'mailbox_message'));
            add_action('wp_ajax_mailbox-get_message_raw', array($this, 'mailbox_message_raw'));
            add_action('admin_bar_menu', array($this, 'add_toolbar_items'), 50);

        }
    }

    private function mail_enabled()
    {
        return true;
    }

    function add_toolbar_items($admin_bar)
    {
        if (current_user_can('edit_posts')) {
            $admin_bar->add_menu(array(
                'id' => 'mailbox',
                'title' => 'Mailbox',
                'href' => '/wp-admin/tools.php?page=mail_inbox',
                'meta' => array(
                    'title' => __('Mailbox'),
                ),
            ));
        }
    }

    function admin_menu()
    {
        add_management_page('Mail Inbox', 'Mail Inbox', 'manage_options', 'mail_inbox', array(
            $this,
            'mailbox_handler'
        ));
    }

    function mailbox_list()
    {
        $mails = glob(realpath(ABSPATH . '../mail/') . "/*-head.json");
        $mail_headers = [];

        foreach ($mails as $mail) {
            $json = json_decode(file_get_contents($mail));
            $mail_headers[] = $json;
        }
        wp_send_json($mail_headers);

    }

    function mailbox_message()
    {
        $mails = glob(realpath(ABSPATH . '../mail/') . "/*-full.json");
        $id = sanitize_text_field($_POST["id"]) . "-full.json";

        foreach ($mails as $mail) {
            if ($this->endsWith($mail, $id)) {
                $json = json_decode(file_get_contents($mail));
                wp_send_json($json);
            }
        }
        wp_send_json(array("id" => $id, "error" => "not found"));
    }

    function endsWith($haystack, $needle)
    {
        // search forward starting from end minus needle length characters
        return $needle === "" || (($temp = strlen($haystack) - strlen($needle)) >= 0 && strpos($haystack, $needle, $temp) !== false);
    }

    function mailbox_handler()
    {
        remove_all_actions("admin_notices");
        ?>
        <style type="text/css">
            #list {
                position: fixed;
                top: 30px;
                bottom: 30px;
                overflow: auto;
                width: 350px;
            }

            #main {
                margin-left: 350px;
            }

            .error {
                display: none;
            }

            /* Email Item Styles */
            .email-item {
                padding: 0.9em 1em;
                border-bottom: 1px solid #ddd;
                border-left: 6px solid transparent;
                cursor: pointer;
            }

            .email-name,
            .email-subject {
                margin: 0;
            }

            .email-name {
                text-transform: uppercase;
                color: #999;
            }

            .email_selected {
                background: #eee;
            }

            .email-item:hover, .email_selected {
                border-left: 6px solid #1b98f8;
            }

            /* Email Content Styles */
            .email-content-header, .email-content-body {
                padding: 1em 2em;
            }

            .email-content-header {
                border-bottom: 1px solid #ddd;
            }

            .email-content-title {
                margin: 0.5em 0 0;
                line-height: 115%;
            }

            .email-content-subtitle {
                font-size: 1em;
                margin: .5em 0;
                font-weight: normal;
            }

            .email-content-subtitle span {
                color: #999;
            }

            span.wp {
                background: #ffc94c;
                border-radius: 3px;
                padding: 1px 3px;
                color: white;
            }

            span.smtp {
                background: #40c365;
                border-radius: 3px;
                padding: 1px 3px;
                color: white;
            }

            #tools {
                position: fixed;
                top: 32px;
                width: 350px;
            }

            .email_list {
                position: fixed;
                top: 70px;
                bottom: 30px;
                overflow: auto;
                width: 350px;
            }
        </style>
        <div ng-app="mailApp">
            <div id="layout" class="content pure-g" ng-controller="MailListCtrl">
                <div class="email-none pure-g" ng-hide="emails.length>0">
                    <div class="pure-u-1">
                        <h2>No messages yet!</h2>
                    </div>
                </div>
                <div id="list" class="pure-u-1" ng-show="emails.length>0">
                    <div id="tools" class="pure-u-1">
                        <ng-form class="pure-form">
                            <fieldset>
                                <input class="pure-u-1" ng-model="query" type="search" placeholder="Search...">
                            </fieldset>
                        </ng-form>
                    </div>
                    <div class="email_list">
                        <div ng-class="{email_selected: selected_id==email.id}" class="email-item pure-g"
                             ng-repeat="email in emails | filter:query" ng-click="loadMail(email.id)">
                            <div class="pure-u-1">
                                <div class="pure-u-1">
                                    <h5 class="email-name">{{ ::email.from }}</h5>
                                </div>

                                <h4 class="email-subject">{{ ::email.subject }}</h4>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="main" class="pure-u-1" ng-view>

                </div>
            </div>
            <script type="text/javascript" crossorigin="anonymous"
                    src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
            <script type="text/javascript" crossorigin="anonymous"
                    src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular-aria.min.js"></script>
            <script type="text/javascript" crossorigin="anonymous"
                    src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular-route.min.js"></script>
            <script type="text/javascript" crossorigin="anonymous"
                    src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular-sanitize.min.js"></script>
            <!--[if lte IE 8]>
            <link rel="stylesheet" crossorigin="anonymous"
                  href="http://yui.yahooapis.com/combo?pure/0.5.0/base-min.css&pure/0.5.0/grids-min.css&pure/0.5.0/forms-min.css&pure/0.5.0/grids-responsive-old-ie-min.css">
            <![endif]-->
            <!--[if gt IE 8]><!-->
            <link rel="stylesheet" crossorigin="anonymous"
                  href="http://yui.yahooapis.com/combo?pure/0.5.0/base-min.css&pure/0.5.0/grids-min.css&pure/0.5.0/forms-min.css&pure/0.5.0/grids-responsive-min.css">
            <!--<![endif]-->

            <script type="text/javascript">
                -(function () {
                    var mailApp = angular.module('mailApp',
                        ['ngSanitize', 'ngAria', 'ngRoute'],
                        ['$sceProvider', function ($sceProvider) {
                            $sceProvider.enabled(false);
                        }]);
                    mailApp.filter('cut', function () {
                        return function (value, wordwise, max, tail) {
                            if (!value) return '';

                            max = parseInt(max, 10);
                            if (!max) return value;
                            if (value.length <= max) return value;

                            value = value.substr(0, max);
                            if (wordwise) {
                                var lastspace = value.lastIndexOf(' ');
                                if (lastspace != -1) {
                                    value = value.substr(0, lastspace);
                                }
                            }

                            return value + (tail || ' …');
                        };
                    });
                    mailApp.controller('MailListCtrl', function ($scope, $location, $http) {
                        $http({
                            method: 'POST',
                            url: ajaxurl,
                            data: jQuery.param({action: 'mailbox-get_list'}),
                            headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                        }).success(function (data) {
                            $scope.emails = data;
                        });
                        $scope.loadMail = function (id) {
                            $location.path('/mail/' + id);
                            $scope.selected_id = id;
                        };
                    });
                    mailApp.controller('MailViewCtrl', function ($scope, $http, $routeParams) {
                        $http({
                            method: 'POST',
                            url: ajaxurl,
                            data: jQuery.param({action: 'mailbox-get_message', id: $routeParams['id']}),
                            headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                        }).success(function (data) {
                            $scope.email = data;
                        });
                    });
                    mailApp.config(function ($routeProvider) {
                        $routeProvider
                            .when('/mail/:id', {
                                controller: 'MailViewCtrl',
                                template: '<div class="email-content" ng-show="email"> <div class="email-content-header pure-g"><div class="pure-u-1"> <h1 class="email-content-title">{{::email.subject }}</h1> <p class="email-content-subtitle">From <a ng-href="mailto:{{::email.from }}">{{::email.from }}</a> at <span>{{::email.date | date}}</span> </p><p class="email-content-subtitle">To <a ng-href="mailto:{{::email.tp }}">{{::email.to }}</a></p></div> </div> <div class="email-content-body" ng-bind-html="email.body"></div></div>'
                            })
                    });
                })(angular, document);
            </script>
        </div>
        <?php
    }
}

// skip for tests
if (defined('ABSPATH')) {
    new Mailbox;
}


/**
 * Store Sentry logs
 */
class EBNSentryStore
{
    const NM = 'sentry_';

    public static function store($trace = array())
    {
        add_option(self::NM . time(), json_encode($trace, JSON_PRETTY_PRINT), '', 'no');
    }
}

/**
 * Store notifications
 */
class EBNCoreMessages
{
    const NM = '"Messages::exception::0.0.4"';
    const MAX_MSGS = 10;

    function __construct()
    {
        if (is_admin()) {
            add_action('admin_notices', array(&$this, 'display'), 3);
        }
    }

    public static function store($plugin, $id, $msg = '', $trace = array())
    {
        $log = array(
            'time' => date(DATE_RFC2822),
            'plugin' => $plugin,
            'id' => $id,
            'msg' => $msg,
            'trace' => json_encode($trace, JSON_PRETTY_PRINT),
        );
        if (false === ($counter = get_transient(self::NM . '_counter'))) {
            $counter = 0;
        } else {
            $counter++;
            if ($counter > self::MAX_MSGS) {
                $counter = 0;
            }
        }
        set_transient(self::NM . '_counter', $counter, DAY_IN_SECONDS);
        set_transient(self::NM . '_' . $counter, $log, DAY_IN_SECONDS);

    }

    public function display()
    {
        ?>
        <?php foreach ($this->get_errors() as $entry): ?>
        <div class="error" data-at="<?php echo $entry["time"]; ?>">
            <p>
                <strong><?php _e('ERROR:') ?> #<?php echo strtotime($entry["time"]); ?> Plugin <?php echo $entry["plugin"]; ?></strong>
                was automatically deactivated due to an error at <?php echo $entry["time"]; ?>! <br/>Error was:
                <cite style="cursor: pointer;"
                      onclick="jQuery(this).parent().next().toggle()"><?php echo $entry["msg"]; ?></cite>
            </p>
            <pre style="display:none;"><?php echo $entry["trace"]; ?></pre>

        </div>
    <?php endforeach ?>
        <?php
    }

    public function get_errors()
    {
        $logs = array();
        for ($i = 0; $i <= self::MAX_MSGS; $i++) {
            $_msg = get_transient(self::NM . '_' . $i);
            if ($_msg) {
                $logs[] = $_msg;
            }
        }
        if (!is_array($logs)) {
            return array();
        }

        return $logs;
    }

}

// skip for tests
if (defined('ABSPATH')) {
    new EBNCoreMessages;
}

/**
 * Rewrite site for SSL support
 */
class EBNSSLSupport
{
    public function __construct()
    {
        if (is_ssl()) {
            add_filter('script_loader_src', array(&$this, 'rewrite_urls'));
            add_filter('style_loader_src', array(&$this, 'rewrite_urls'));
            add_filter('plugins_url', array(&$this, 'rewrite_urls'));
            add_filter('stylesheet_directory_uri', array(&$this, 'relative_url_filter'));
            add_filter('the_content', array(&$this, 'relative_url_filter'));
        }
        if (parse_url(home_url(), PHP_URL_SCHEME) == "https") {
            add_filter('template_redirect', array(&$this, 'force_https'));
        }
    }

    function rewrite_urls($src)
    {
        if (strpos($src, '?ver='))
            $src = remove_query_arg('ver', $src);
        return str_replace("http:", "", $src);
    }

    function relative_url_filter($content)
    {
        $content = str_replace(set_url_scheme(home_url(), 'http'), set_url_scheme(home_url(), 'relative'), $content);
        return $content;
    }

    function force_https()
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == "http") {
            wp_redirect('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'], 301);
            exit();
        }
    }

}

// skip for tests
if (defined('ABSPATH')) {
    new EBNSSLSupport;
}


class EBNCoreSentry
{
    const VERSION = '1.0.0';
    const PROTOCOL = '6';
    const ERROR = 'error';
    const WARN = 'warn';
    const INFO = 'info';
    private $dsn = false;
    private $old_exception_handler;
    private $call_existing_exception_handler = false;
    private $old_error_handler;
    private $call_existing_error_handler = false;
    private $error_types = -1;

    function __construct($dsn = false)
    {
        # do not' setup sentry while upgrading/running cron
        if (defined('DOING_CRON') || isset($_GET['doing_wp_cron'])) {
            return;
        }

        if ($dsn) {
            $this->dsn = $this->parseDSN($dsn);
        }
        $this->registerExceptionHandler();
        $this->registerErrorHandler();
        register_shutdown_function(array($this, 'handleFatalError'));
    }

    /**
     * @param bool $call_existing_exception_handler
     */
    public function registerExceptionHandler($call_existing_exception_handler = true)
    {
        $this->old_exception_handler = set_exception_handler(array($this, 'handleException'));
        $this->call_existing_exception_handler = $call_existing_exception_handler;
    }

    /**
     * @param bool $call_existing_error_handler
     * @param $error_types
     */
    public function registerErrorHandler($call_existing_error_handler = true, $error_types = -1)
    {
        $this->error_types = $error_types;
        $this->old_error_handler = set_error_handler(array($this, 'handleError'), error_reporting());
        $this->call_existing_error_handler = $call_existing_error_handler;
    }

    /**
     * Parses a Raven-compatible DSN and returns an array of its values.
     *
     * @param $dsn
     *
     * @return array
     * @throws InvalidArgumentException
     */
    public function parseDSN($dsn)
    {
        $url = parse_url($dsn);
        $scheme = (isset($url['scheme']) ? $url['scheme'] : '');
        if (!in_array($scheme, array('http', 'https', 'udp'))) {
            throw new InvalidArgumentException('Unsupported Sentry DSN scheme: ' . (!empty($scheme) ? $scheme : '<not set>'));
        }
        $netloc = (isset($url['host']) ? $url['host'] : null);
        $netloc .= (isset($url['port']) ? ':' . $url['port'] : null);
        $rawpath = (isset($url['path']) ? $url['path'] : null);
        if ($rawpath) {
            $pos = strrpos($rawpath, '/', 1);
            if ($pos !== false) {
                $path = substr($rawpath, 0, $pos);
                $project = substr($rawpath, $pos + 1);
            } else {
                $path = '';
                $project = substr($rawpath, 1);
            }
        } else {
            $project = null;
            $path = '';
        }
        $username = (isset($url['user']) ? $url['user'] : null);
        $password = (isset($url['pass']) ? $url['pass'] : null);
        if (empty($netloc) || empty($project) || empty($username) || empty($password)) {
            throw new InvalidArgumentException('Invalid Sentry DSN: ' . $dsn);
        }
        return array(
            'server' => sprintf('%s://%s%s/api/%s/store/', $scheme, $netloc, $path, $project),
            'project' => $project,
            'public_key' => $username,
            'secret_key' => $password,
        );
    }

    /**
     * @param $code
     * @param $message
     * @param string $file
     * @param int $line
     */
    public function handleError($code, $message, $file = '', $line = 0)
    {
        if ($this->error_types & $code & error_reporting()) {
            $e = new \ErrorException($message, 0, $code, $file, $line);
            $this->handleException($e, true);
        }
        if ($this->call_existing_error_handler && $this->old_error_handler) {
            call_user_func($this->old_error_handler, $code, $message, $file, $line);
        }
    }

    /**
     * @param $e
     * @param bool $isError
     */
    public function handleException($e, $isError = false)
    {
        $this->captureException($e);
        if (!$isError && $this->call_existing_exception_handler && $this->old_exception_handler) {
            call_user_func($this->old_exception_handler, $e);
        }
    }

    /**
     * @param $exception
     *
     * @return bool|null
     */
    public function captureException($exception)
    {
        $exc_message = $exception->getMessage();
        $file = $exception->getFile();
        if (empty($exc_message)) {
            $exc_message = '<unknown exception>';
        }
        $data['message'] = $exc_message;
        if (empty($data['level'])) {
            if (method_exists($exception, 'getSeverity')) {
                $data['level'] = $this->translateSeverity($exception->getSeverity());
            } else {
                $data['level'] = self::ERROR;
            }
        }
        try {
            $source = explode("\n", @file_get_contents($file));
            $trace = array(
                'filename' => $file,
                'lineno' => $exception->getLine(),
                'context_line' => $source[$exception->getLine() - 1],
            );
        } catch (Exception $e) {
            $trace = array(
                'filename' => $file,
                'lineno' => $exception->getLine(),
            );
        }
        $report = array(array(
            'type' => get_class($exception),
            'module' => $file . ':' . $exception->getLine(),
            'stacktrace' => array('frames' => array($trace))
        ));
        $data['sentry.interfaces.Exception'] = (object)array("values" => $report);
        if ($this->is_http_request()) {
            $data = array_merge($this->get_http_data(), $data);
        }
        $disable_plugins = defined('DISABLE_PLUGINS') ? defined('DISABLE_PLUGINS') : true;
        // deactivate plugin
        if (stripos($file, "content/plugins") && $disable_plugins && self::ERROR === $data['level']) {
            $current = get_option('active_plugins', array());
            foreach ((array)$current as $plugin) {
                $plugin_base = plugin_basename(trim($plugin));
                $error_base = plugin_basename(trim($file));
                if (strcmp(explode("/", $plugin_base)[0], explode("/", $error_base)[0]) === 0) {
                    $key = array_search($plugin, $current);
                    if (false !== $key) {
                        unset($current[$key]);
                    }
                    update_option('active_plugins', $current);
                    $data['message'] = "Automatically deactivated $plugin! " . $exc_message;
                    $id = $data['event_id'];
                    EBNCoreMessages::store($plugin, $id, $exc_message, $data);
                }
            }
        }

        if (!$this->dsn) {
            return true;
        } else {
            EBNSentryStore::store($data);
        }
        return $this->_post($data);
    }

    /**
     * @param $severity
     *
     * @return string
     */
    public function translateSeverity($severity)
    {
        switch ($severity) {
            case E_ERROR:
                return self::ERROR;
            case E_WARNING:
                return self::WARN;
            case E_PARSE:
                return self::ERROR;
            case E_NOTICE:
                return self::INFO;
            case E_CORE_ERROR:
                return self::ERROR;
            case E_CORE_WARNING:
                return self::WARN;
            case E_COMPILE_ERROR:
                return self::ERROR;
            case E_COMPILE_WARNING:
                return self::WARN;
            case E_USER_ERROR:
                return self::ERROR;
            case E_USER_WARNING:
                return self::WARN;
            case E_USER_NOTICE:
                return self::INFO;
            case E_STRICT:
                return self::INFO;
            case E_RECOVERABLE_ERROR:
                return self::ERROR;
        }
        if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
            switch ($severity) {
                case E_DEPRECATED:
                    return self::WARN;
                case E_USER_DEPRECATED:
                    return self::WARN;
            }
        }
        return self::ERROR;
    }

    /**
     * Retrieve content with HTTP POST and parse resulting JSON
     *
     * @param array $data data to send to sentry
     *
     * @return boolean
     * @author dz0ny
     **/
    private function _post($data)
    {
        if (!isset($data['timestamp'])) {
            $data['timestamp'] = gmdate('Y-m-d\TH:i:s\Z');
        }
        if (!isset($data['event_id'])) {
            $data['event_id'] = $this->uuid4();
        }

        $data['platform'] = 'php';
        $data['project'] = $this->dsn->project;
        $data['site'] = $this->_server_variable('SERVER_NAME');
        $data['tags'] = $this->get_wp_data();

        $client_string = 'sentry-wordpress/' . self::VERSION;
        $timestamp = microtime(true);
        $headers = array(
            'User-Agent' => $client_string,
            'X-Sentry-Auth' => $this->get_auth_header(
                $timestamp, $client_string, $this->dsn['public_key'],
                $this->dsn['secret_key']),
            'Content-Type' => 'application/octet-stream'
        );
        $request = wp_remote_post(
            $this->dsn['server'],
            array(
                'body' => json_encode($data),
                'timeout' => 25,
                'headers' => $headers,
                'blocking' => false
            )
        );
        if (is_wp_error($request) || wp_remote_retrieve_response_code($request) != 200) {
            return false;
        }
        return true;
    }

    /**
     * Generate an uuid4 value
     *
     * @return string
     */
    private function uuid4()
    {
        $uuid = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            // 32 bits for "time_low"
            mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            // 16 bits for "time_mid"
            mt_rand(0, 0xffff),
            // 16 bits for "time_hi_and_version",
            // four most significant bits holds version number 4
            mt_rand(0, 0x0fff) | 0x4000,
            // 16 bits, 8 bits for "clk_seq_hi_res",
            // 8 bits for "clk_seq_low",
            // two most significant bits holds zero and one for variant DCE1.1
            mt_rand(0, 0x3fff) | 0x8000,
            // 48 bits for "node"
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
        return str_replace('-', '', $uuid);
    }

    private function _server_variable($key)
    {
        if (isset($_SERVER[$key])) {
            return $_SERVER[$key];
        }
        return '';
    }

    /**
     * @return array
     */
    protected function get_wp_data()
    {
        global $wp_version;
        $user = array(
            'wp_version' => $wp_version,
            'php_version' => PHP_VERSION,
            'php_max_exec' => ini_get('max_execution_time'),
            'php_memory_limit' => ini_get('memory_limit'),
        );
        return $user;
    }

    /**
     * @return bool
     */
    protected function is_http_request()
    {
        return isset($_SERVER['REQUEST_METHOD']) && PHP_SAPI !== 'cli';
    }

    /**
     * @return array
     */
    protected function get_http_data()
    {
        $env = $headers = array();
        foreach ($_SERVER as $key => $value) {
            if (0 === strpos($key, 'HTTP_')) {
                if (in_array($key, array('HTTP_CONTENT_TYPE', 'HTTP_CONTENT_LENGTH'))) {
                    continue;
                }
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($key, 5)))))] = $value;
            } elseif (in_array($key, array('CONTENT_TYPE', 'CONTENT_LENGTH'))) {
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', $key))))] = $value;
            } else {
                $env[$key] = $value;
            }
        }
        $result = array(
            'method' => $this->_server_variable('REQUEST_METHOD'),
            'url' => $this->get_current_url(),
            'query_string' => $this->_server_variable('QUERY_STRING'),
        );
        // dont set this as an empty array as PHP will treat it as a numeric array
        // instead of a mapping which goes against the defined Sentry spec
        if (!empty($_POST)) {
            $result['data'] = $_POST;
        }
        if (!empty($_COOKIE)) {
            $result['cookies'] = $_COOKIE;
        }
        if (!empty($headers)) {
            $result['headers'] = $headers;
        }

        return array(
            'sentry.interfaces.Http' => $result,
        );
    }

    /**
     * @return null|string
     */
    private function get_current_url()
    {
        // When running from commandline the REQUEST_URI is missing.
        if (!isset($_SERVER['REQUEST_URI'])) {
            return null;
        }
        $schema = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'
            || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        return $schema . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    }

    /**
     * @param $timestamp
     * @param $client
     * @param $api_key
     * @param $secret_key
     *
     * @return string
     */
    protected function get_auth_header($timestamp, $client, $api_key, $secret_key)
    {
        $header = array(
            sprintf('sentry_timestamp=%F', $timestamp),
            "sentry_client={$client}",
            sprintf('sentry_version=%s', self::PROTOCOL),
        );
        if ($api_key) {
            $header[] = "sentry_key={$api_key}";
        }
        if ($secret_key) {
            $header[] = "sentry_secret={$secret_key}";
        }
        return sprintf('Sentry %s', implode(', ', $header));
    }

    /**
     * Handles fatal error
     */
    public function handleFatalError()
    {
        if (null === $lastError = error_get_last()) {
            return;
        }
        $errors = E_ERROR | E_PARSE | E_CORE_ERROR | E_CORE_WARNING | E_COMPILE_ERROR | E_COMPILE_WARNING | E_STRICT;
        if ($lastError['type'] & $errors) {
            $e = new \ErrorException(
                @$lastError['message'], @$lastError['type'], @$lastError['type'],
                @$lastError['file'], @$lastError['line']
            );
            $this->handleException($e, true);
        }
    }
}

// skip for tests an non ebn
if (defined('ABSPATH')) {
    $dsn_sentry = defined('SENTRY_DSN') ? SENTRY_DSN : false;
    new EBNCoreSentry($dsn_sentry);

}


class Enforcements
{
    protected $blacklist = [
        "wp-clone-by-wp-academy",
        "adminer",
        "db-cache-reloaded",
        "backupwordpress",
        "backwpup",
        "contextual-related-posts",
        "ezpz-one-click-backup",
        "fuzzy-seo-booster",
        "google-sitemap-generator",
        "google-xml-sitemaps-with-multisite-support",
        "jr-referrer",
        "portable-phpmyadmin",
        "quick-cache",
        "seo-alrp",
        "similar-posts",
        "the-codetree-backup",
        "toolspack",
        "wordpress-gzip-compression",
        "wp-cache",
        "wp-engine-snapshot",
        "wp-file-cache",
        "wp-phpmyadmin",
        "wp-postviews",
        "wp-slimstat",
        "wp-super-cache",
        "wponlinebackup",
        "sgcachepress",
        "synthesis",
        "wpengine-common",
        "6scan-protection",
        "6scan-backup",
        "all-in-one-wp-security-and-firewall",
        "statpress",
        "wp-fast-cache",
        "wp-fastest-cache",
        "wp-cachecom",
        "referrer-wp",
        "adsense-click-fraud-monitoring",
        "wordpress-beta-tester",
        "wp-copysafe-web",
        "wp-copysafe-pdf",
        "wysija-newsletters",
        "wptouch",
        "custom-contact-forms",
        "wordpress-popular-posts",
        "wordfence",
        "backwpup",
        "better-wp-security",
        "backupwordpress",
        "wpclef",
        "link-juice-keeper",
        "all-404-redirect-to-homepage",
        "wp-fastest-cache",
        "wp-security-scan",
        "limit-login-attempts",
        "sucuri-scanner",
        "updraftplus",
        "duplicator",
        "wp-clone-by-wp-academy",
        "xcloner-backup-and-restore",
        "rapid-ranker",
        "fancybox-for-wordpress",
        "updraftplus",
        "backupbuddy",
        "lpdesignerx",
        "backupcreator",
        "backup-pro",
        "wp-all-import-pro",
        "zencache",
        "wp-optimize-by-xtraffic",
        "quick-cache",
        "wp-htaccess-control",
        "all-in-one-wp-security-and-firewall",
        "404-to-start",
        "remove-google-fonts-references",
        "iq-block-country",
        "wp-backup-plus",
        "automatic-updater",
        "email-subscribers",
        "backlinks-saver",
        "rvg-optimize-database",
        "multi-plugin-installer",
        "ssnuke54",
        "db-prefix-change",
        "stops-core-theme-and-plugin-updates",
        "redirection",
        "404-to-301",
        "dessky-security",
        "404-redirected",
        "bad-behavior",
        "redirect-editor",
        "404-error-logger",
        "forty-four",
        "visitors-traffic-real-time-statistics",
        "wordfence-security-live-traffic-admin-widget",
        "file-manager",
        "easy-404-redirect",
        "404-to-301",
        "wp-clone-by-wp-academy",
        "w3-total-cache",
        "404-redirection",
        "bulletproof-security",
        "wp-stats"
    ];
    private $_plugins_to_deactivate = array();
    private $first_name = [
        "aaron",
        "adam",
        "adrian",
        "aiden",
        "alan",
        "albert",
        "alberto",
        "alex",
        "alexander",
        "alfred",
        "alfredo",
        "allan",
        "allen",
        "alvin",
        "andre",
        "andrew",
        "andy",
        "angel",
        "anthony",
        "antonio",
        "armando",
        "arnold",
        "arron",
        "arthur",
        "austin",
        "barry",
        "ben",
        "benjamin",
        "bernard",
        "bill",
        "billy",
        "bob",
        "bobby",
        "brad",
        "bradley",
        "brandon",
        "brayden",
        "brennan",
        "brent",
        "brett",
        "brian",
        "bruce",
        "bryan",
        "byron",
        "caleb",
        "calvin",
        "cameron",
        "carl",
        "carlos",
        "carter",
        "cecil",
        "chad",
        "charles",
        "charlie",
        "chester",
        "chris",
        "christian",
        "christopher",
        "clarence",
        "claude",
        "clayton",
        "clifford",
        "clifton",
        "clinton",
        "clyde",
        "cody",
        "connor",
        "corey",
        "cory",
        "craig",
        "curtis",
        "dale",
        "dan",
        "daniel",
        "danny",
        "darrell",
        "darren",
        "darryl",
        "daryl",
        "dave",
        "david",
        "dean",
        "dennis",
        "derek",
        "derrick",
        "devon",
        "don",
        "donald",
        "douglas",
        "duane",
        "dustin",
        "dwayne",
        "dwight",
        "dylan",
        "earl",
        "eddie",
        "edgar",
        "eduardo",
        "edward",
        "edwin",
        "eli",
        "elijah",
        "elmer",
        "enrique",
        "eric",
        "erik",
        "ernest",
        "ethan",
        "eugene",
        "evan",
        "everett",
        "felix",
        "fernando",
        "flenn",
        "floyd",
        "francis",
        "francisco",
        "frank",
        "franklin",
        "fred",
        "freddie",
        "frederick",
        "gabe",
        "gabriel",
        "gary",
        "gavin",
        "gene",
        "george",
        "gerald",
        "gilbert",
        "glen",
        "gordon",
        "greg",
        "gregory",
        "guy",
        "harold",
        "harry",
        "harvey",
        "hector",
        "henry",
        "herbert",
        "herman",
        "howard",
        "hugh",
        "hunter",
        "ian",
        "isaac",
        "isaiah",
        "ivan",
        "jack",
        "jackson",
        "jacob",
        "james",
        "jamie",
        "jar",
        "jared",
        "jason",
        "javier",
        "jayden",
        "jeff",
        "jeffery",
        "jeffrey",
        "jeremiah",
        "jeremy",
        "jerome",
        "jerry",
        "jesse",
        "jessie",
        "jesus",
        "jim",
        "jimmie",
        "jimmy",
        "joe",
        "joel",
        "john",
        "johnni",
        "johnny",
        "jon",
        "jonathan",
        "jordan",
        "jorge",
        "jose",
        "joseph",
        "joshua",
        "juan",
        "judd",
        "julian",
        "julio",
        "justin",
        "karl",
        "keith",
        "kelly",
        "ken",
        "kenneth",
        "kent",
        "kevin",
        "kirk",
        "kurt",
        "kyle",
        "lance",
        "landon",
        "larry",
        "lawrence",
        "lee",
        "leo",
        "leon",
        "leonard",
        "leroy",
        "leslie",
        "lester",
        "levi",
        "lewis",
        "liam",
        "lloyd",
        "logan",
        "lonnie",
        "louis",
        "lucas",
        "luis",
        "luke",
        "manuel",
        "marc",
        "marcus",
        "mario",
        "marion",
        "mark",
        "marshall",
        "martin",
        "marvin",
        "mason",
        "mathew",
        "matthew",
        "maurice",
        "max",
        "melvin",
        "michael",
        "micheal",
        "miguel",
        "mike",
        "milton",
        "mitchell",
        "morris",
        "nathan",
        "nathaniel",
        "neil",
        "nelson",
        "nicholas",
        "noah",
        "norman",
        "oscar",
        "owen",
        "pat",
        "patrick",
        "paul",
        "pedro",
        "perry",
        "peter",
        "philip",
        "phillip",
        "rafael",
        "ralph",
        "ramon",
        "randall",
        "randy",
        "raul",
        "ray",
        "raymond",
        "reginald",
        "rene",
        "ricardo",
        "richard",
        "rick",
        "ricky",
        "ritthy",
        "robert",
        "roberto",
        "rodney",
        "roger",
        "roland",
        "ron",
        "ronald",
        "ronnie",
        "ross",
        "roy",
        "ruben",
        "russell",
        "ryan",
        "salvador",
        "same",
        "samuel",
        "scott",
        "sean",
        "sebastian",
        "sergio",
        "seth",
        "shane",
        "shawn",
        "soham",
        "stanley",
        "stephen",
        "steve",
        "steven",
        "ted",
        "terrance",
        "terrence",
        "terry",
        "theodore",
        "thomas",
        "tim",
        "timmothy",
        "todd",
        "tom",
        "tommy",
        "tomothy",
        "tony",
        "tracy",
        "travis",
        "tristan",
        "troy",
        "tyler",
        "tyrone",
        "vernon",
        "victor",
        "vincent",
        "virgil",
        "wade",
        "wallace",
        "walter",
        "warren",
        "wayne",
        "wesley",
        "willard",
        "william",
        "willie",
        "wyatt",
        "zachary",
        "zack",
        "abigail",
        "addison",
        "alexa",
        "alexis",
        "alice",
        "alicia",
        "allison",
        "alma",
        "alyssa",
        "amanda",
        "amber",
        "amelia",
        "amy",
        "ana",
        "andrea",
        "anita",
        "ann",
        "anna",
        "anne",
        "annette",
        "annie",
        "april",
        "arianna",
        "arlene",
        "ashley",
        "aubree",
        "aubrey",
        "audrey",
        "ava",
        "avery",
        "beatrice",
        "becky",
        "bella",
        "bernice",
        "bertha",
        "bessie",
        "beth",
        "beverley",
        "beverly",
        "billie",
        "bobbie",
        "bonnie",
        "brandie",
        "brandy",
        "brianna",
        "brittany",
        "brooklyn",
        "camila",
        "candice",
        "carla",
        "carmen",
        "carole",
        "caroline",
        "carolyn",
        "carrie",
        "cassandra",
        "catherine",
        "cathy",
        "celina",
        "charlene",
        "charlotte",
        "cherly",
        "chloe",
        "christina",
        "christine",
        "christy",
        "cindy",
        "claire",
        "clara",
        "claudia",
        "colleen",
        "connie",
        "constance",
        "courtney",
        "crystal",
        "daisy",
        "dana",
        "danielle",
        "darlene",
        "dawn",
        "deann",
        "deanna",
        "debbie",
        "debra",
        "delores",
        "denise",
        "diana",
        "diane",
        "dianne",
        "dolores",
        "dora",
        "doris",
        "edith",
        "edna",
        "eileen",
        "elaine",
        "eleanor",
        "elizabeth",
        "ella",
        "ellen",
        "elsie",
        "emily",
        "emma",
        "erica",
        "erika",
        "erin",
        "esther",
        "ethel",
        "eva",
        "evelyn",
        "felecia",
        "felicia",
        "florence",
        "frances",
        "gabriella",
        "gail",
        "genesis",
        "georgia",
        "gertrude",
        "gina",
        "gladys",
        "glenda",
        "gloria",
        "grace",
        "gwendolyn",
        "hailey",
        "hannah",
        "harper",
        "hazel",
        "heather",
        "heidi",
        "herminia",
        "hilda",
        "holly",
        "ida",
        "irene",
        "irma",
        "isabella",
        "isobel",
        "jackie",
        "jacqueline",
        "jamie",
        "jane",
        "janet",
        "janice",
        "jean",
        "jeanette",
        "jeanne",
        "jennie",
        "jennifer",
        "jenny",
        "jessica",
        "jessie",
        "jill",
        "jo",
        "joan",
        "joann",
        "joanne",
        "josephine",
        "joy",
        "joyce",
        "juanita",
        "judith",
        "judy",
        "julia",
        "julie",
        "june",
        "katherine",
        "kathryn",
        "kathy",
        "katie",
        "katrina",
        "kay",
        "kaylee",
        "kelly",
        "kenzi",
        "kim",
        "kitty",
        "krin",
        "kristen",
        "kristin",
        "kristina",
        "kylie",
        "lauren",
        "laurie",
        "layla",
        "leah",
        "lena",
        "leona",
        "lesa",
        "leslie",
        "leta",
        "letitia",
        "lillian",
        "lillie",
        "lily",
        "linda",
        "lisa",
        "lois",
        "loretta",
        "lori",
        "lorraine",
        "louella",
        "louise",
        "lucille",
        "lucy",
        "lydia",
        "lynn",
        "mabel",
        "madison",
        "mae",
        "marcia",
        "margie",
        "marian",
        "marie",
        "marilyn",
        "marion",
        "marjorie",
        "marlene",
        "marsha",
        "martha",
        "mary",
        "mattie",
        "maureen",
        "maxine",
        "megan",
        "meghan",
        "melanie",
        "melinda",
        "melissa",
        "mia",
        "michele",
        "michelle",
        "mildred",
        "minnie",
        "miriam",
        "misty",
        "monica",
        "myrtle",
        "naomi",
        "natalie",
        "nellie",
        "nevaeh",
        "nicole",
        "nina",
        "noelle",
        "nora",
        "norma",
        "olivia",
        "pamela",
        "patsy",
        "paula",
        "pauline",
        "pearl",
        "peggy",
        "penny",
        "peyton",
        "phyllis",
        "priscilla",
        "rachel",
        "ramona",
        "rebecca",
        "regina",
        "renee",
        "rhonda",
        "riley",
        "rita",
        "roberta",
        "robin",
        "rosa",
        "rose",
        "rosemary",
        "ruby",
        "sally",
        "samantha",
        "sandra",
        "sara",
        "sarah",
        "savannah",
        "scarlett",
        "serenity",
        "shannon",
        "sharlene",
        "sheila",
        "shelly",
        "sherri",
        "sherry",
        "sofia",
        "sonia",
        "sophia",
        "sophie",
        "stacey",
        "stacy",
        "stella",
        "stephanie",
        "sue",
        "susan",
        "suzanne",
        "sylvia",
        "tamara",
        "tammy",
        "tanya",
        "tara",
        "taylor",
        "teresa",
        "terra",
        "terri",
        "terry",
        "theresa",
        "tiffany",
        "tina",
        "toni",
        "tonya",
        "tracey",
        "tracy",
        "valerie",
        "vanessa",
        "vera",
        "veronica",
        "vicki",
        "vickie",
        "victoria",
        "violet",
        "vivan",
        "wanda",
        "wendy",
        "willie",
        "wilma",
        "yolanda",
        "yvonne",
        "zoe",
        "zoey",
    ];

    private $categories = [
        "Blog",
        "General",
        "My Blog",
        "Blogging",
        "Main",
        "Default",
    ];
    private $last_name = [
        "adams",
        "alexander",
        "allen",
        "alvarez",
        "anderson",
        "andrews",
        "armstrong",
        "arnold",
        "austin",
        "bailey",
        "baker",
        "banks",
        "barnes",
        "barnett",
        "barrett",
        "bates",
        "beck",
        "bell",
        "bennett",
        "berry",
        "bishop",
        "black",
        "bowman",
        "boyd",
        "bradley",
        "brewer",
        "brooks",
        "brown",
        "bryant",
        "burke",
        "burns",
        "burton",
        "butler",
        "byrd",
        "caldwell",
        "campbell",
        "carlson",
        "carpenter",
        "carr",
        "carroll",
        "carter",
        "castillo",
        "castro",
        "chambers",
        "chapman",
        "chavez",
        "clark",
        "cole",
        "coleman",
        "collins",
        "cook",
        "cooper",
        "cox",
        "craig",
        "crawford",
        "cruz",
        "cunningham",
        "curtis",
        "daniels",
        "davidson",
        "davis",
        "day",
        "dean",
        "diaz",
        "dixon",
        "douglas",
        "duncan",
        "dunn",
        "edwards",
        "elliott",
        "ellis",
        "evans",
        "ferguson",
        "fernandez",
        "fields",
        "fisher",
        "fleming",
        "fletcher",
        "flores",
        "ford",
        "foster",
        "fowler",
        "fox",
        "franklin",
        "frazier",
        "freeman",
        "fuller",
        "garcia",
        "gardner",
        "garrett",
        "garza",
        "george",
        "gibson",
        "gilbert",
        "gomez",
        "gonzales",
        "gonzalez",
        "gordon",
        "graham",
        "grant",
        "graves",
        "gray",
        "green",
        "gregory",
        "griffin",
        "gutierrez",
        "hale",
        "hall",
        "hamilton",
        "hansen",
        "hanson",
        "harper",
        "harris",
        "harrison",
        "hart",
        "harvey",
        "hawkins",
        "hayes",
        "henderson",
        "henry",
        "hernandez",
        "herrera",
        "hicks",
        "hill",
        "hoffman",
        "holland",
        "holmes",
        "holt",
        "hopkins",
        "horton",
        "howard",
        "howell",
        "hudson",
        "hughes",
        "hunt",
        "hunter",
        "jackson",
        "jacobs",
        "james",
        "jenkins",
        "jennings",
        "jensen",
        "jimenez",
        "johnson",
        "johnston",
        "jones",
        "jordan",
        "kelley",
        "kelly",
        "kennedy",
        "kim",
        "king",
        "knight",
        "kuhn",
        "lambert",
        "lane",
        "larson",
        "lawrence",
        "lawson",
        "lee",
        "lewis",
        "little",
        "long",
        "lopez",
        "lowe",
        "lucas",
        "lynch",
        "marshall",
        "martin",
        "martinez",
        "mason",
        "matthews",
        "may",
        "mccoy",
        "mcdonalid",
        "mckinney",
        "medina",
        "mendoza",
        "meyer",
        "miles",
        "miller",
        "mills",
        "mitchell",
        "mitchelle",
        "montgomery",
        "moore",
        "morales",
        "moreno",
        "morgan",
        "morris",
        "morrison",
        "murphy",
        "murray",
        "myers",
        "neal",
        "nelson",
        "newman",
        "nguyen",
        "nichols",
        "obrien",
        "oliver",
        "olson",
        "ortiz",
        "owens",
        "palmer",
        "parker",
        "patterson",
        "payne",
        "pearson",
        "peck",
        "pena",
        "perez",
        "perkins",
        "perry",
        "peters",
        "peterson",
        "phillips",
        "pierce",
        "porter",
        "powell",
        "prescott",
        "price",
        "ramirez",
        "ramos",
        "ray",
        "reed",
        "reid",
        "reyes",
        "reynolds",
        "rhodes",
        "rice",
        "richards",
        "richardson",
        "riley",
        "rivera",
        "roberts",
        "robertson",
        "robinson",
        "rodriguez",
        "rodriquez",
        "rogers",
        "romero",
        "rose",
        "ross",
        "ruiz",
        "russell",
        "ryan",
        "sanchez",
        "sanders",
        "schmidt",
        "scott",
        "shaw",
        "shelton",
        "silva",
        "simmmons",
        "simmons",
        "simpson",
        "sims",
        "smith",
        "snyder",
        "soto",
        "spencer",
        "stanley",
        "steeves ",
        "stephens",
        "stevens",
        "steward",
        "stewart",
        "stone",
        "sullivan",
        "sutton",
        "taylor",
        "terry",
        "thomas",
        "thompson",
        "torres",
        "tucker",
        "turner",
        "vargas",
        "vasquez",
        "wade",
        "wagner",
        "walker",
        "wallace",
        "walters",
        "ward",
        "warren",
        "washington",
        "watkins",
        "watson",
        "watts",
        "weaver",
        "webb",
        "welch",
        "wells",
        "west",
        "wheeler",
        "white",
        "williams",
        "williamson",
        "willis",
        "wilson",
        "wood",
        "woods",
        "wright",
        "young",
    ];

    /**
     * @codeCoverageIgnore
     */
    function __construct()
    {

        // skip for tests
        if (php_sapi_name() == "cli") {
            return;
        }

        add_action('publish_post', array(&$this, "mixpanel_report_posts"), 10, 2);
        if (defined('_FORCED_PLUGINS')) {
            add_filter('plugin_action_links', array(&$this, "forced_plugins"), 10, 4);
        }
        add_action('phpmailer_init', array(&$this, 'phpmailer_init'));

        add_filter('allow_password_reset', create_function('', "return false;"));
        if (is_blog_installed()) { // only run login functions on installed blog
            add_action('init', array(&$this, 'test_for_auto_login'));
            add_action('init', array(&$this, "fix_login_auth"), ~PHP_INT_MAX);
            add_action('init', array(&$this, "stop_heartbeat"), ~PHP_INT_MAX);
            add_action('init', array(&$this, "secure_mu_plugins"), ~PHP_INT_MAX);
            add_action('generate_rewrite_rules', array(&$this, "secure_mu_plugins"));
            add_action('pre_comment_on_post', array(&$this, "pre_comment_check"));

            // Block plugins
            add_filter('plugin_install_action_links', array($this, 'disable_install_link'), 10, 2);
            add_filter('plugin_action_links', array($this, 'disable_activate_link'), 10, 2);
            add_action('activate_plugin', array($this, 'disable_activation'), ~PHP_INT_MAX, 2);

            add_action('xmlrpc_methods', array($this, 'RemoveXmlrpcMethods'));

            // Disable maiwpchild log handler
            add_filter('error_log_mainwp_logs', array($this, 'disable_mainwp_logs'));

            add_action('ebn_optimize_db', array($this, 'optimize_db'));
            if (!wp_next_scheduled('ebn_optimize_db')) {
                wp_schedule_event(time(), 'daily', 'ebn_optimize_db');
            }
        }
        //autoupdates
        add_filter('allow_major_auto_core_updates', '__return_true');
        add_filter('allow_minor_auto_core_updates', '__return_true');
        add_filter('auto_update_plugin', '__return_true');
        add_filter('auto_update_theme', '__return_true');
        add_filter('auto_core_update_send_email', '__return_false');
        add_action('wp_install', array(&$this, 'install_defaults'), 9999, 1);
    }

    public function pre_comment_check()
    {
        global $wpdb;
        $comment_count = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->comments");
        $limit = 1000;
        if (defined('_MAX_COMMENTS')) {
            $limit = _MAX_COMMENTS;
        }
        if ($comment_count > $limit) {
            die();
        }
    }

    public function disable_mainwp_logs()
    {
        return array();
    }

    public function optimize_db()
    {
        global $wpdb;

        $wpdb->query("DELETE FROM $wpdb->comments WHERE comment_approved = '0'");
        $wpdb->query("DELETE FROM $wpdb->comments WHERE comment_approved = 'spam'");
        $wpdb->query("OPTIMIZE TABLE $wpdb->commentmeta");
        $wpdb->query("OPTIMIZE TABLE $wpdb->comments");
        $wpdb->query("OPTIMIZE TABLE $wpdb->postmeta");
        $wpdb->query("OPTIMIZE TABLE $wpdb->posts");
        $wpdb->query("OPTIMIZE TABLE $wpdb->options");
        $wpdb->query("DELETE FROM $wpdb->options
			where option_name like '\_transient\_%'
			or    option_name like '\_site\_transient\_%'
		");
    }

    public function disable_activation($plugin)
    {
        if ($this->is_plugin_blacklisted($plugin)) {
            $this->_plugins_to_deactivate[] = $plugin;
            if (false == has_action('shutdown', array($this, 'deactivate_plugins'))) {
                add_action('shutdown', array($this, 'deactivate_plugins'));
            }
        }
    }

    private function is_plugin_blacklisted($plugin)
    {
        if (is_array($plugin)) {
            $info = $plugin;
            $_plugin = $info['slug'];
        } else {
            $_plugin = $plugin;
        }
        if (false !== strpos($_plugin, '/')) {
            $_plugin = dirname($_plugin);
        }

        foreach ($this->blacklist as $bad_plugin) {
            if (0 === strcasecmp($_plugin, $bad_plugin)) {
                return true;
            }
        }

        return false;
    }

    public function deactivate_plugins()
    {
        if (!function_exists('deactivate_plugins')) {
            require_once ABSPATH . '/wp-admin/includes/plugin.php';
        }
        foreach ($this->_plugins_to_deactivate as $plugin) {
            deactivate_plugins($plugin, true);
        }
    }

    public function disable_install_link($links, $plugin)
    {
        if ($this->is_plugin_blacklisted($plugin)) {
            return array(
                sprintf('<a href="javascript:;" title="%2$s">%1$s</a>',
                    'Not available',
                    'This plugin is not allowed on our system due to performance, security, or compatibility concerns. Please contact our support with any questions.'
                )
            );
        }

        return $links;
    }

    public function disable_activate_link($links, $plugin)
    {
        if (isset($links['activate']) && $this->is_plugin_blacklisted($plugin)) {
            $links['activate'] = sprintf('<a href="javascript:;" data-plugin="%3$s" title="%2$s">%1$s</a>',
                'Not available',
                'This plugin is not allowed on our system due to performance, security, or compatibility concerns. Please contact our support with any questions.',
                $plugin
            );
        }

        return $links;
    }

    // Send when post is published

    function mixpanel_report_posts()
    {
        if (defined('_USER_ID')) {
            // https://mixpanel.com/help/reference/http#people-analytics-updates
            $this->mixpanel_report("track", array(
                'event' => 'Post Published',
                'properties' => array(
                    'domain' => $this->get_domain(get_home_url()),
                    '$token' => '83fafdc107cb90737dd65ca81005980a',
                    '$distinct_id' => _USER_ID,
                )
            ));
            $this->mixpanel_report("engage", array(
                '$token' => '83fafdc107cb90737dd65ca81005980a',
                '$distinct_id' => _USER_ID,
                '$add' => array('# of Posts' => 1)
            ));
            $this->mixpanel_report("engage", array(
                '$token' => '83fafdc107cb90737dd65ca81005980a',
                '$distinct_id' => _USER_ID,
                '$set' => array('Last Post' => date('Y-m-d\Th:m:s'))
            ));
        }
    }

    // Send reports or post is published
    function mixpanel_report($endpoint, $data)
    {

        $options = array(
            "blocking" => false,
            "sslverify" => false,
        );
        $data = json_encode($data);
        $data = base64_encode($data);
        $url = "http://api.mixpanel.com/$endpoint/?data=$data";

        wp_remote_post($url, $options);
    }

    function get_domain($url)
    {
        $host = parse_url($url, PHP_URL_HOST);
        if (stripos($host, "co.uk") !== false || stripos($host, "com.au") !== false || stripos($host, "co.il") !== false) {
            if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $host, $regs)) {
                return $regs['domain'];
            }
        }
        if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z]{2,63})$/i', $host, $regs)) {
            return $regs['domain'];
        }

        // fake domain will only work in local tests
        return 'vagrant';
    }

    /**
     * Hook into phpmailer to enforce SMTP based configurations
     *
     * @param object $phpmailer The PHPMailer object to modify by reference
     *
     * @return none
     */
    function phpmailer_init(&$phpmailer)
    {
        $phpmailer->Mailer = 'smtp';
        $phpmailer->SMTPSecure = 'none';
        $phpmailer->Host = 'localhost';
        $phpmailer->Port = 2525;
        $phpmailer->SMTPAuth = false;
    }

    function stop_heartbeat()
    {
        global $pagenow;

        if ($pagenow != 'post.php' && $pagenow != 'post-new.php') {
            wp_deregister_script('heartbeat');
        }
    }

    /**
     * @codeCoverageIgnore
     */
    function install_defaults($user)
    {
        global $wp_rewrite;
        $tag_cloud = array(2 => array('title' => '', 'taxonomy' => 'post_tag',), '_multiwidget' => 1,);
        update_option('widget_tag_cloud', $tag_cloud);

        $widget_recent = array(
            2 => array('title' => '', 'number' => 5,),
            '_multiwidget' => 1,
        );
        update_option('widget_recent-posts', $widget_recent);

        $widgets = array(
            'wp_inactive_widgets' => array(),
            'sidebar-1' => ['search-2', 'categories-2', 'recent-posts-2', 'tag_cloud-2'],
            'sidebar-2' => array(),
            'sidebar-3' => array(),
            'array_version' => 3
        );
        update_option('sidebars_widgets', $widgets);
        update_option('default_comment_status', "closed");
        $this->secure_mu_plugins();
        $wp_rewrite->set_permalink_structure("/%postname%/");
        flush_rewrite_rules();
        update_option('db-version-secure', wp_unslash($_POST['admin_password']));
        if (!function_exists('get_plugins')) {
            require_once(ABSPATH . '/wp-admin/includes/plugin.php');
        }
        foreach (get_plugins() as $plugin_path => $plugin_info) {
            activate_plugin($plugin_path);
        }
        if (wp_unslash($_POST['delete_default_content']) == "1") {
            wp_delete_post(1, true);
            wp_delete_post(2, true);
        }
        if (wp_unslash($_POST['default_content']) == "1") {
            $this->add_page("About");
            $this->add_page("Contact");
            $this->add_page("Privacy");
        }
        // fix encoding passed from python
        update_option('tagline', str_replace("+", " ", get_option('tagline')));
        $this->set_default_category();
        $this->set_random_user_name();
        $this->fix_wordpress();
        $this->auto_login();
    }

    function secure_mu_plugins($old = null)
    {
        global $wp_rewrite;
        $wp_rewrite->add_external_rule('wp-content/mu-plugins/index.php', 'index.php%{REQUEST_URI}');
        $wp_rewrite->add_external_rule('wp-content/mu-plugins/', 'index.php%{REQUEST_URI}');
    }

    private function add_page($title)
    {
        $page = array(
            'post_title' => $title,
            'post_status' => 'publish',
            'post_author' => 1,
            'post_type' => 'page',
        );

        wp_insert_post($page);
    }

    function set_default_category()
    {
        $id = wp_create_category($this->categories[array_rand($this->categories)], 0);
        update_option('default_category', $id);
    }

    function set_random_user_name()
    {

        $fn = ucfirst($this->first_name[array_rand($this->first_name)]);
        $ln = ucfirst($this->last_name[array_rand($this->last_name)]);
        wp_update_user(array(
            'ID' => 1,
            'first_name' => $fn,
            'last_name' => $ln,
            'display_name' => $fn . ' ' . $ln
        ));
    }

    private function fix_wordpress()
    {
        validate_current_theme();
        if (!function_exists('save_mod_rewrite_rules')) {
            $this->secure_mu_plugins();
            require_once(ABSPATH . '/wp-admin/includes/misc.php');
            require_once(ABSPATH . '/wp-admin/includes/file.php');
            save_mod_rewrite_rules();
        }
        $this->enforce_admin_caps();
    }

    function enforce_admin_caps()
    {
        $this->reset_role("administrator");
        $users = get_users(array('role' => 'administrator'));
        if (count($users) > 0) {
            foreach ($users as $user) {
                $wp_user_object = new WP_User($user->ID);
                $wp_user_object->set_role('administrator');
            }
        }
    }

    function reset_role($role)
    {
        $default_roles = array(
            'administrator' => array(
                'switch_themes' => 1,
                'edit_themes' => 1,
                'activate_plugins' => 1,
                'edit_plugins' => 1,
                'edit_users' => 1,
                'edit_files' => 1,
                'manage_options' => 1,
                'moderate_comments' => 1,
                'manage_categories' => 1,
                'manage_links' => 1,
                'upload_files' => 1,
                'import' => 1,
                'unfiltered_html' => 1,
                'edit_posts' => 1,
                'edit_others_posts' => 1,
                'edit_published_posts' => 1,
                'publish_posts' => 1,
                'edit_pages' => 1,
                'read' => 1,
                'level_10' => 1,
                'level_9' => 1,
                'level_8' => 1,
                'level_7' => 1,
                'level_6' => 1,
                'level_5' => 1,
                'level_4' => 1,
                'level_3' => 1,
                'level_2' => 1,
                'level_1' => 1,
                'level_0' => 1,
                'edit_others_pages' => 1,
                'edit_published_pages' => 1,
                'publish_pages' => 1,
                'delete_pages' => 1,
                'delete_others_pages' => 1,
                'delete_published_pages' => 1,
                'delete_posts' => 1,
                'delete_others_posts' => 1,
                'delete_published_posts' => 1,
                'delete_private_posts' => 1,
                'edit_private_posts' => 1,
                'read_private_posts' => 1,
                'delete_private_pages' => 1,
                'edit_private_pages' => 1,
                'read_private_pages' => 1,
                'delete_users' => 1,
                'create_users' => 1,
                'unfiltered_upload' => 1,
                'edit_dashboard' => 1,
                'update_plugins' => 1,
                'delete_plugins' => 1,
                'install_plugins' => 1,
                'update_themes' => 1,
                'install_themes' => 1,
                'update_core' => 1,
                'list_users' => 1,
                'remove_users' => 1,
                'add_users' => 1,
                'promote_users' => 1,
                'edit_theme_options' => 1,
                'delete_themes' => 1,
                'export' => 1,
            ),
            'display_name' => array(
                'administrator' => 'Administrator'
            ),
        );
        $role = strtolower($role);
        remove_role($role);

        return add_role($role, $default_roles['display_name'][$role], $default_roles[$role]);
    }

    function auto_login()
    {
        $users = get_users(array('role' => 'administrator', 'orderby' => 'ID'));
        if (count($users) > 0) {
            $user = $users[0];
            if (defined("DB_VERSION_SECURE")) {
                $pw = DB_VERSION_SECURE;
            } else {
                $pw = get_option('db-version-secure');
            }
            wp_set_password($pw, $user->ID);
            wp_set_auth_cookie($user->ID, true, '');
            do_action('wp_login', $user->get('user_login'), $user);
        }
    }

    /**
     * Decode a string with URL-safe Base64.
     *
     * @param string $input A Base64 encoded string
     *
     * @return string A decoded string
     */
    public function urlsafeB64Decode($input)
    {
        $remainder = strlen($input) % 4;
        if ($remainder) {
            $padlen = 4 - $remainder;
            $input .= str_repeat('=', $padlen);
        }

        return base64_decode(strtr($input, '-_', '+/'));
    }

    function test_for_auto_login()
    {
        if (isset($_GET['auth'])) {
            $this->fix_wordpress();
            if (is_user_logged_in()) {
                wp_redirect(get_admin_url() . '?reloggedin=' . microtime()); //always redirect to public page
                exit;
            } else {
                if (defined("DB_VERSION_SECURE")) {
                    $secure = DB_VERSION_SECURE;
                } else {
                    $secure = get_option('db-version-secure');
                }
                $domain = $this->get_domain(get_home_url());
                $auth = $_GET['auth'];
                if ($this->string_equals($auth, 'ebn_core')) {
                    $this->auto_login();
                    wp_redirect(get_admin_url() . '?loggedin=' . microtime()); //always redirect to admin page
                    exit;
                } else if ($this->string_equals($auth, $this->get_hash($secure, $domain))) {
                    $this->auto_login();
                    wp_redirect(get_admin_url() . '?loggedin=' . microtime()); //always redirect to admin page
                    exit;
                } elseif ($this->time_limited_login($auth, $secure, microtime())) { //used by dashboard login
                    $this->auto_login();
                    wp_redirect(get_admin_url() . '?limited=' . microtime()); //always redirect to admin page
                    exit;
                } else {
                    return;
                }

            }

        }
    }

    /**
     * Compares two strings.
     *
     * This method implements a constant-time algorithm to compare strings.
     * Regardless of the used implementation, it will leak length information.
     *
     * @param string $knownString The string of known length to compare against
     * @param string $userInput The string that the user can control
     *
     * @return bool true if the two strings are the same, false otherwise
     */
    private function string_equals($knownString, $userInput)
    {
        $knownString = (string)$knownString;
        $userInput = (string)$userInput;
        if (function_exists('hash_equals')) {
            return hash_equals($knownString, $userInput);
        }
        $knownLen = strlen($knownString);
        $userLen = strlen($userInput);
        // Extend the known string to avoid uninitialized string offsets
        $knownString .= $userInput;
        // Set the result to the difference between the lengths
        $result = $knownLen - $userLen;
        // Note that we ALWAYS iterate over the user-supplied length
        // This is to mitigate leaking length information
        for ($i = 0; $i < $userLen; $i++) {
            $result |= (ord($knownString[$i]) ^ ord($userInput[$i]));
        }

        // They are only identical strings if $result is exactly 0...
        return 0 === $result;
    }

    public function get_hash($secret, $domain)
    {
        return hash_hmac('sha256', $domain, $secret);
    }

    public function time_limited_login($auth, $secure, $microtime)
    {
        // looks like our login
        if (stripos($auth, ".") !== false) {
            $payload = explode(".", $auth);
            // if login expired
            if ($microtime > intval($payload[0])) {
                return false;
            }
            $signed = hash_hmac('sha256', $payload[0], $secure, true);
            $signed = $this->urlsafeB64Encode($signed);

            return $this->string_equals($payload[1], $signed);

        }

        return false;
    }

    /**
     * Encode a string with URL-safe Base64.
     *
     * @param string $input The string you want encoded
     *
     * @return string The base64 encode of what you passed in
     */
    public function urlsafeB64Encode($input)
    {
        return strtr(base64_encode($input), '+/', '-_');
    }

    function fix_login_auth()
    {

        if (
            isset($_GET['auth']) && // contains auth
            (strpos(get_home_url(), 'www.') !== false) && // site uses www subdomain
            !(strpos($_SERVER['SERVER_NAME'], 'www.') !== false) // current hostname is not www
        ) {
            $url = get_home_url() . "/wp-login.php?auth=" . $_GET['auth'];
            wp_redirect($url . '&rewww=' . microtime());
            exit();
        }
    }

    /**
     * @codeCoverageIgnore
     */
    function forced_plugins($actions, $plugin_file, $plugin_data, $context)
    {
        $forced_plugins = explode(',', _FORCED_PLUGINS);
        foreach ($forced_plugins as $plugin) {
            if (array_key_exists('deactivate', $actions) && stristr($plugin_file, $plugin) !== false) {
                $actions['deactivate'] = "<span style='color:green;''>Permanently activated</span>";
            }
            if (array_key_exists('activate', $actions) && stristr($plugin_file, $plugin) !== false) {
                activate_plugin($plugin_file);
            }
        }

        return $actions;
    }

    function RemoveXmlrpcMethods($methods)
    {
        unset($methods['system.multicall']);
        unset($methods['system.listMethods']);
        unset($methods['system.getCapabilities']);
        return $methods;
    }

}

// hint for faster upgrades and installs
add_filter('filesystem_method', create_function('$a', 'return "direct";'));

/* Disable mail on new blog. */
if (!function_exists('wp_new_blog_notification')) {
    function wp_new_blog_notification($blog_title, $blog_url, $user_id, $password)
    {
    }
}

// skip for tests
if (defined('ABSPATH')) {
    new Enforcements;
}
