/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.Messages;
import JUpload.ProgressListener;
import JUpload.actions.CaptureScreenAction;
import JUpload.actions.ClipboardPasteAction;
import JUpload.actions.SettingsAction;
import JUpload.gui.AboutWindow;
import JUpload.gui.HelpWindow;
import JUpload.gui.RealtimeResponsePanel;
import JUpload.gui.StatPanel;
import JUpload.gui.UploadStatus;
import JUpload.startup;
import JUpload.swingVersion.IFileSelectionListener;
import JUpload.swingVersion.IQueueListener;
import JUpload.swingVersion.IQueueView;
import JUpload.swingVersion.JFileList;
import JUpload.swingVersion.JFileListNew;
import JUpload.swingVersion.JFileTable;
import JUpload.swingVersion.JFileTree;
import JUpload.swingVersion.WalkerThread;
import JUpload.swingVersion.myAddListener;
import JUpload.swingVersion.myDropListener;
import JUpload.swingVersion.myRemoveListener;
import JUpload.swingVersion.myStopListener;
import JUpload.swingVersion.myUploadListener;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import JUpload.utilities.ProxyConfig;
import JUpload.utilities.QueueSelectedFiles;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import netscape.javascript.JSObject;

public class JUpload
extends Applet
implements ActionListener,
MouseListener,
IQueueListener {
    private static final long serialVersionUID = 3258410634071650617L;
    private static final Logger LOG = Logger.getLogger((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getName());
    public static JUpload JUploadInstance;
    public JSObject jsBrowserWindow;
    public JPanel controlPanel;
    public JPanel statuspanel;
    public RealtimeResponsePanel serverResponse;
    public startup applet;
    public JButton add;
    public static final Icon ICON_IDLE;
    public static final Icon ICON_UPLOADING;
    public static final Icon ICON_DONE;
    public static final Icon ICON_ERROR;
    public static final Icon ICON_HELP;
    public static final Icon ICON_CLIPBOARD;
    public static final Icon ICON_CAPTURE;
    public static final Icon ICON_ADD;
    public static final Icon ICON_REMOVE;
    public static final Icon ICON_UPLOAD;
    public static final Icon ICON_STOP;
    public static final Icon ICON_LIST;
    public static final Icon ICON_TREE;
    public JButton remove;
    public JButton upload;
    protected JPanel buttonPanel;
    protected JPanel infoPanel;
    protected JSplitPane jsp;
    protected JPopupMenu popup;
    protected StatPanel statpanel;
    String host = null;
    private QueueSelectedFiles queueSelectedFiles;
    private boolean isReady = false;
    myRemoveListener myRemove;
    myUploadListener myUpload;
    protected myAddListener myAdd;
    private Vector progressMeterListener;
    WalkerThread walkerThread;
    private Vector fileSelectionListeners;
    private List trustedCerts;
    public JButton stopButton;
    myStopListener myStop;
    private Iterator iter;
    static /* synthetic */ Class class$JUpload$swingVersion$JUpload;

    public JUpload(startup t_applet) {
        this.applet = t_applet;
        this.progressMeterListener = new Vector();
        Configurator.readConfiguration(t_applet);
        this.doLocaleSetup();
        ProxyConfig.readConfiguration();
        try {
            this.jsBrowserWindow = t_applet.jsBrowserWindow;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
        this.start();
    }

    private void doLocaleSetup() {
        Locale locale = Configurator.getLocale();
        if (locale != null) {
            Messages.setLocale(locale);
            Locale.setDefault(locale);
            Configurator.readConfiguration(this.applet);
        }
    }

    public QueueSelectedFiles getQueueSelectedFiles() {
        return this.queueSelectedFiles;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public Applet getStartupApplet() {
        return this.applet;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("help_applet_tag")) {
            new HelpWindow(Configurator.helpPage());
        }
        if (e.getActionCommand().equalsIgnoreCase("help_about")) {
            new AboutWindow(this.applet);
        }
    }

    public void init() {
        LOG.info("JUpload initializing");
        JUploadInstance = this;
        System.out.println(Configurator.strBanner + " at " + this.applet.getCodeBase());
        this.fileSelectionListeners = new Vector();
        this.initLookAndFeel();
        try {
            this.applet.getAppletContext().showStatus(this.getAppletInfo());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.host = this.applet.getCodeBase().getHost();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.queueSelectedFiles = new QueueSelectedFiles();
        JTabbedPane queueViewsTab = this.createTabbedPane();
        this.serverResponse = new RealtimeResponsePanel();
        this.addFileSelectionListener(this.serverResponse);
        if (Configurator.getRemoveBorders()) {
            this.serverResponse.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.createPopupMenu();
        this.controlPanel.add(this.popup);
        if (!Configurator.getDisableContextMenu()) {
            this.controlPanel.addMouseListener(this);
        } else {
            LOG.info("Context menu is disabled by configuration.");
        }
        this.buttonPanel = new JPanel();
        BoxLayout blButtonpanel = new BoxLayout(this.buttonPanel, 1);
        this.buttonPanel.setLayout(blButtonpanel);
        this.add = new JButton(Configurator.getLabelAdd(), ICON_ADD);
        this.remove = new JButton(Configurator.getLabelRemove(), ICON_REMOVE);
        this.upload = new JButton(Configurator.getLabelUpload(), ICON_UPLOAD);
        this.stopButton = new JButton(Configurator.getLabelStopUpload(), ICON_STOP);
        if (Configurator.getHideAddButton()) {
            this.add.setVisible(false);
        }
        if (Configurator.getHideRemoveButton()) {
            this.remove.setVisible(false);
        }
        if (Configurator.getHideUploadButton()) {
            this.upload.setVisible(false);
        }
        if (Configurator.getHideStopButton()) {
            this.stopButton.setVisible(false);
        }
        this.add.setToolTipText(Configurator.getAddToolTip());
        this.add.setMnemonic(65);
        this.remove.setToolTipText(Configurator.getRemoveToolTip());
        this.remove.setMnemonic(82);
        this.upload.setToolTipText(Configurator.getUploadToolTip());
        this.upload.setMnemonic(85);
        this.stopButton.setToolTipText(Configurator.getLabelStopUpload());
        this.stopButton.setMnemonic(83);
        this.remove.setEnabled(false);
        this.upload.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.queueSelectedFiles.addQueueListener(this);
        this.buttonPanel.add(this.add);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.buttonPanel.add(this.remove);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.buttonPanel.add(this.upload);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.buttonPanel.add(this.stopButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add.setAlignmentX(0.5f);
        this.remove.setAlignmentX(0.5f);
        this.upload.setAlignmentX(0.5f);
        this.stopButton.setAlignmentX(0.5f);
        this.controlPanel.add((Component)this.buttonPanel, "North");
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BorderLayout());
        this.statpanel = new StatPanel();
        this.statpanel.updateColor();
        this.statpanel.setAlignmentX(0.5f);
        this.statuspanel = new JPanel();
        this.statuspanel.setLayout(new BorderLayout());
        this.statuspanel.setAlignmentX(0.5f);
        this.infoPanel.add((Component)this.statpanel, "North");
        this.infoPanel.add((Component)this.statuspanel, "Center");
        this.controlPanel.add((Component)this.infoPanel, "Center");
        this.jsp = new JSplitPane();
        if (Configurator.getRemoveBorders()) {
            this.jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        Dimension prefDimension = new Dimension(this.applet.getWidth(), this.applet.getHeight() - 5);
        this.jsp.setPreferredSize(prefDimension);
        this.jsp.setSize(prefDimension);
        this.jsp.setDividerSize(3);
        this.jsp.setDividerLocation(0.7);
        if (Configurator.getMainSplitpaneLocation() > 0 && Configurator.getMainSplitpaneLocation() < this.applet.getWidth()) {
            this.jsp.setDividerLocation(Configurator.getMainSplitpaneLocation());
        }
        if (Configurator.getRealTimeResponse()) {
            JSplitPane jspLeft = new JSplitPane();
            if (Configurator.getRemoveBorders()) {
                jspLeft.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            jspLeft.setOrientation(0);
            jspLeft.add((Component)queueViewsTab, "top");
            jspLeft.add((Component)this.serverResponse, "bottom");
            jspLeft.setDividerSize(3);
            jspLeft.setDividerLocation(0.7);
            if (Configurator.getLeftSplitpaneLocation() > 0 && Configurator.getLeftSplitpaneLocation() < this.applet.getWidth()) {
                jspLeft.setDividerLocation(Configurator.getLeftSplitpaneLocation());
            }
            this.jsp.add((Component)jspLeft, "left");
        } else {
            this.jsp.add((Component)queueViewsTab, "left");
        }
        if (Configurator.getShowStatusPanel()) {
            this.jsp.add((Component)this.controlPanel, "right");
        } else {
            this.controlPanel.setMaximumSize(new Dimension(0, 0));
            this.controlPanel.setPreferredSize(new Dimension(0, 0));
            this.controlPanel.setMinimumSize(new Dimension(0, 0));
            this.controlPanel.setSize(new Dimension(0, 0));
            this.jsp.add((Component)this.controlPanel, "right");
            this.jsp.setDividerSize(0);
            this.jsp.setDividerLocation(this.jsp.getWidth() - 1);
        }
        this.jsp.validate();
        this.applet.add(this.jsp);
        this.myAdd = new myAddListener(JUpload.getInstance());
        this.myRemove = new myRemoveListener(JUpload.getInstance(), this.queueSelectedFiles);
        this.myUpload = new myUploadListener(JUpload.getInstance(), JUpload.getInstance().applet.m_Context);
        this.myStop = new myStopListener(JUpload.getInstance());
        this.add.addActionListener(this.myAdd);
        this.remove.addActionListener(this.myRemove);
        this.upload.addActionListener(this.myUpload);
        this.stopButton.addActionListener(this.myStop);
        this.walkerThread = WalkerThread.getInstance();
        this.walkerThread.addFiles(Configurator.getPreselectedFiles());
    }

    private JTabbedPane createTabbedPane() {
        JScrollPane scroller;
        IQueueView queueView;
        JTabbedPane queueViewsTab = new JTabbedPane();
        String tabViewsParam = Configurator.getShowTabViews();
        if (tabViewsParam == null || tabViewsParam.equals("") || tabViewsParam.indexOf("list") >= 0) {
            queueView = this.createQueueViewList();
            this.queueSelectedFiles.addView(queueView);
            scroller = new JScrollPane(queueView.getComponent());
            if (Configurator.getRemoveBorders()) {
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            queueViewsTab.addTab(Messages.getString("JUpload.TabbedPane.List"), ICON_LIST, scroller);
        }
        if (tabViewsParam == null || tabViewsParam.equals("") || tabViewsParam.indexOf("newlist") >= 0) {
            queueView = this.createQueueViewNewList();
            this.queueSelectedFiles.addView(queueView);
            scroller = new JScrollPane(queueView.getComponent());
            if (Configurator.getRemoveBorders()) {
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            queueViewsTab.addTab(Messages.getString("JUpload.TabbedPane.ListNew"), ICON_LIST, scroller);
        }
        if (tabViewsParam == null || tabViewsParam.equals("") || tabViewsParam.indexOf("details") >= 0) {
            queueView = this.createQueueViewDetails();
            this.queueSelectedFiles.addView(queueView);
            scroller = new JScrollPane(queueView.getComponent());
            if (Configurator.getRemoveBorders()) {
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            queueViewsTab.addTab(Messages.getString("JUpload.TabbedPane.Details"), ICON_TREE, scroller);
        }
        if (tabViewsParam == null || tabViewsParam.equals("") || tabViewsParam.indexOf("tree") >= 0) {
            queueView = this.createQueueViewTree();
            this.queueSelectedFiles.addView(queueView);
            scroller = new JScrollPane(queueView.getComponent());
            if (Configurator.getRemoveBorders()) {
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            queueViewsTab.addTab(Messages.getString("JUpload.TabbedPane.Tree"), ICON_TREE, scroller);
        }
        return queueViewsTab;
    }

    private IQueueView createQueueViewDetails() {
        JFileTable queueView = new JFileTable(this.queueSelectedFiles);
        DropTarget dt = new DropTarget();
        dt.setComponent(queueView.getComponent());
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new myDropListener(this));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        queueView.getComponent().setDropTarget(dt);
        return queueView;
    }

    private IQueueView createQueueViewList() {
        JFileList queueViewList = new JFileList(this.queueSelectedFiles);
        queueViewList.removeAll();
        JScrollPane listScroller = new JScrollPane(queueViewList.getComponent());
        if (Configurator.getRemoveBorders()) {
            listScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        DropTarget dt = new DropTarget();
        dt.setComponent(queueViewList.getComponent());
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new myDropListener(this));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        return queueViewList;
    }

    private IQueueView createQueueViewNewList() {
        JFileListNew queueViewList = new JFileListNew(this.queueSelectedFiles);
        queueViewList.removeAll();
        JScrollPane listScroller = new JScrollPane(queueViewList.getComponent());
        if (Configurator.getRemoveBorders()) {
            listScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        DropTarget dt = new DropTarget();
        dt.setComponent(queueViewList.getComponent());
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new myDropListener(this));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        return queueViewList;
    }

    private IQueueView createQueueViewTree() {
        JFileTree queueView = new JFileTree(this.queueSelectedFiles);
        DropTarget dt = new DropTarget();
        dt.setComponent(queueView.getComponent());
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new myDropListener(this));
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        queueView.getComponent().setDropTarget(dt);
        return queueView;
    }

    private void initLookAndFeel() {
        String strLookAndFeel = Configurator.getLookAndFeelClass();
        if (strLookAndFeel.equals("")) {
            return;
        }
        try {
            if (strLookAndFeel.equals("com.l2fprod.gui.plaf.skin.SkinLookAndFeel") && Configurator.getSkinThemePackURL() != null) {
                SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((URL)Configurator.getSkinThemePackURL()));
            }
            UIManager.setLookAndFeel(strLookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** Error loading look-and-feel ***");
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, Messages.getString("JUpload.ErrorDialog.GeneralWindowTitle"), 0);
    }

    public void jsClickAdd() {
        LOG.info("JavaScript Click for Add Files");
        boolean eventId = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LOG.info("Asynchronously opening file chooser");
                JUpload.this.myAdd.actionPerformed(null);
            }
        });
    }

    public void jsClickRemove() {
        LOG.info("JavaScript Click for Remove Files");
        boolean eventId = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JUpload.this.myRemove.actionPerformed(null);
            }
        });
    }

    public void jsClickUpload() {
        LOG.info("JavaScript Click for Upload Files");
        boolean eventId = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JUpload.this.myUpload.actionPerformed(null);
            }
        });
    }

    public String jsGetFileAt(int i) {
        QueueSelectedFiles qsf = this.getQueueSelectedFiles();
        if (qsf == null) {
            return null;
        }
        return qsf.getFileAt(i).toString();
    }

    public Integer jsGetFileNumber() {
        QueueSelectedFiles qsf = this.getQueueSelectedFiles();
        if (qsf == null) {
            return null;
        }
        Debug.println(this, "jsGetFileNumber() returns " + qsf.size());
        return new Integer(qsf.size());
    }

    public Object jsGetFileSizeAt(int i) {
        QueueSelectedFiles qsf = this.getQueueSelectedFiles();
        if (qsf == null) {
            return null;
        }
        return new Integer((int)qsf.getFileAt(i).length());
    }

    public void mouseClicked(MouseEvent e) {
        Debug.println(this, "mouseClicked: " + e.toString());
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 3) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Debug.println(this, "mouseReleased: " + e.toString());
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void start() {
        Debug.println(this, "JUpload() start() running from host " + this.host);
        this.isReady = true;
        if (this.jsBrowserWindow != null) {
            Debug.println(this, "Calling JavaScript function 'init()'");
            try {
                this.jsBrowserWindow.call("init", this.applet);
            }
            catch (Exception e) {
                System.out.println("There is no JavaScript function init() to call. Ignoring.");
            }
        } else {
            Debug.println(this, "No JavaScript available, cannot call function 'init()'");
        }
        this.doAutostartUpload();
    }

    private void doAutostartUpload() {
        if (Configurator.getAutostartUpload()) {
            this.myUpload.actionPerformed(null);
        }
    }

    public void stop() {
        this.isReady = false;
        Debug.println(this, "JUpload() stop(). ");
        Debug.println(this, "   stop() removing listScroller and buttonpanel");
        this.applet.remove(this.controlPanel);
        this.controlPanel = null;
        if (null != this.walkerThread) {
            WalkerThread.kill();
            this.walkerThread = null;
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu(Messages.getString("JUpload.30"));
        JMenuItem mi = new JMenuItem(Messages.getString("JUpload.31"));
        mi.setMnemonic(74);
        mi.setIcon(ICON_HELP);
        mi.setActionCommand("help_about");
        mi.addActionListener(this);
        this.popup.add(mi);
        mi = new JMenuItem(Messages.getString("JUpload.33"));
        mi.setIcon(ICON_HELP);
        mi.setMnemonic(72);
        mi.setActionCommand("help_applet_tag");
        mi.addActionListener(this);
        this.popup.add(mi);
        this.popup.addSeparator();
        mi = new JMenuItem(Messages.getString("JUpload.Menuitem.CaptureScreen"));
        mi.setIcon(ICON_CAPTURE);
        mi.setMnemonic(83);
        mi.addActionListener(new CaptureScreenAction());
        if (!Configurator.getCaptureScreen()) {
            mi.setEnabled(false);
        }
        this.popup.add(mi);
        mi = new JMenuItem(Messages.getString("JUpload.Menuitem.PasteFromClipboard"));
        mi.setIcon(ICON_CLIPBOARD);
        mi.setMnemonic(67);
        mi.addActionListener(new ClipboardPasteAction());
        this.popup.add(mi);
        mi = new JMenuItem(Messages.getString("JUpload.0"));
        mi.setMnemonic(69);
        mi.setIcon(ICON_LIST);
        mi.addActionListener(new SettingsAction());
        this.popup.add(mi);
    }

    public void walkFileTree(MyFile[] fileArray) {
        this.walkerThread.addFiles(fileArray);
    }

    public void addProgressMeterListener(ProgressListener l) {
        this.progressMeterListener.add(l);
    }

    public Vector getProgressMeterListener() {
        return this.progressMeterListener;
    }

    public static JUpload getInstance() {
        return JUploadInstance;
    }

    public void jsRemoveFileAt(int i) {
        QueueSelectedFiles qsf = this.getQueueSelectedFiles();
        if (qsf == null) {
            return;
        }
        qsf.removeFileAt(i);
    }

    public Integer jsGetTotalProgressbarValue() {
        long t = UploadStatus.getInstance().getProgressInformationObject().getTotalPercentageAsInteger();
        Integer value = new Integer((int)t);
        return value;
    }

    public void errorMessage(String t_strMessage) {
        JOptionPane.showConfirmDialog(this, t_strMessage);
    }

    public void queueChanging(DefaultListModel listModel) {
    }

    public void queueChanged(DefaultListModel listModel) {
        if (listModel.size() == 0) {
            this.remove.setEnabled(false);
            this.upload.setEnabled(false);
            this.stopButton.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
            this.upload.setEnabled(true);
        }
    }

    public static void waitForLoad(JApplet applet) {
        while (applet.getAppletContext().getApplet("JUpload") == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addFileSelectionListener(IFileSelectionListener t_listener) {
        Debug.println(this, "Added new file selection listener:" + t_listener);
        this.fileSelectionListeners.addElement(t_listener);
    }

    public void notifyFileSelectionListeners(ListSelectionEvent e) {
        this.iter = this.fileSelectionListeners.iterator();
        while (this.iter.hasNext()) {
            IFileSelectionListener listener = (IFileSelectionListener)this.iter.next();
            listener.selectionChanged(e);
        }
    }

    public void addTrustedCerts(X509Certificate cert) {
        Debug.println(this, "addTrustedCert: " + cert);
        if (this.trustedCerts == null) {
            this.trustedCerts = new ArrayList();
        }
        this.trustedCerts.add(cert);
    }

    public boolean isTrustedCert(X509Certificate cert) {
        Debug.println(this, "isTrustedCert: " + cert);
        return this.trustedCerts != null && this.trustedCerts.contains(cert);
    }

    public void jsCaptureScreenshot() {
        CaptureScreenAction action = new CaptureScreenAction();
        action.actionPerformed(null);
    }

    public void jsPasteClipboardImage() {
        ClipboardPasteAction action = new ClipboardPasteAction();
        action.actionPerformed(null);
    }

    public static MyFile[] convertToMyfiles(File[] t_files) {
        MyFile[] myFiles = new MyFile[t_files.length];
        for (int i = 0; i < myFiles.length; ++i) {
            myFiles[i] = t_files[i] instanceof MyFile ? (MyFile)t_files[i] : new MyFile(t_files[i]);
        }
        return myFiles;
    }

    public static MyFile[] convertToMyfiles(File[] t_files, File currentDirectory) {
        MyFile[] myFiles = new MyFile[t_files.length];
        for (int i = 0; i < myFiles.length; ++i) {
            if (t_files[i] instanceof MyFile) {
                myFiles[i] = (MyFile)t_files[i];
                continue;
            }
            myFiles[i] = new MyFile(t_files[i]);
            myFiles[i].setCurrentDirectory(currentDirectory);
        }
        return myFiles;
    }

    public void jsClickStop() {
        boolean eventId = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JUpload.this.myStop.actionPerformed(null);
            }
        });
    }

    public void walkFileTree(List list) {
        this.walkFileTree(list.toArray(new File[0]));
    }

    public void walkFileTree(File[] files) {
        MyFile[] myfiles = new MyFile[files.length];
        for (int i = 0; i < myfiles.length; ++i) {
            myfiles[i] = new MyFile(files[i]);
        }
        this.walkFileTree(myfiles);
    }

    public void removeProgressMeterListener(ProgressListener listener) {
        this.progressMeterListener.remove(listener);
    }

    public void removeFileSelectionListener(IFileSelectionListener listener) {
        this.fileSelectionListeners.remove(listener);
    }

    public Configurator getConfigurator() {
        return new Configurator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ICON_IDLE = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("icon_ok_idle.gif"));
        ICON_UPLOADING = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("icon_ok.gif"));
        ICON_DONE = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_uploaded.png"));
        ICON_ERROR = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_failure.png"));
        ICON_HELP = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_help.png"));
        ICON_CLIPBOARD = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_clipboard.png"));
        ICON_CAPTURE = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_capture.png"));
        ICON_ADD = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_add.png"));
        ICON_REMOVE = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_remove.png"));
        ICON_UPLOAD = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_upload.png"));
        ICON_STOP = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_stop.png"));
        ICON_LIST = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_list.png"));
        ICON_TREE = new ImageIcon((class$JUpload$swingVersion$JUpload == null ? (class$JUpload$swingVersion$JUpload = JUpload.class$("JUpload.swingVersion.JUpload")) : class$JUpload$swingVersion$JUpload).getResource("jicon_tree.png"));
    }
}

