<?php
/*
* RSS Cron Job 
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/

require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/rss_database.php');
require_once(dirname(__FILE__) . '/process_submit.php');

$logger = null;
$indent = 0;

function wtg_cron_post_feed() {
	global $logger, $indent;

	$wtg_option = get_option('wtg_option');
	# registeration of WTG plugin is required to submit the feed.
	if($wtg_option['registration']) {
		$logger = new WTG_Rss_Log();
		$logger->openlog();
		$logger->info(str_repeat(' ', $indent = 0) . 'Cron job triggered.');
		
		$db = new WTG_DB();
		$total = $db->get_job_total();
		$logger->debug(str_repeat(' ', $indent) . "There are {$total} job(s) in the scheduled job list.");
	
		if ($total) { // we may need to post feed again, so schedule the next event
			wtg_schedule_next_event();
		} else {
			wtg_set_cron_job_complete(true);
		}
	
		$count = 0; // salis
		if (isset($wtg_option['site_number_per_thread']))
			$site_number_per_thread = $wtg_option['site_number_per_thread'];
		else $site_number_per_thread = SITE_NUMBER_PER_THREAD_DEFAULT;
		
		while (($job = $db->retrieve_job()) && ($count++ < $site_number_per_thread)) {
			$post = get_post($job->post_id);
			// works for published post only 
			if($post->post_status == 'publish') {
				wtg_submit_feed_to_one_site($job->post_id, $job->feed_name, $job->aggregator_id);
			}
		}
	
		$logger->closelog();
	}
}

function wtg_schedule_next_event() {
	$wtg_option = get_option('wtg_option');
	
	if (isset($wtg_option['cron_interval']))
		$cron_interval = $wtg_option['cron_interval'];
	else $cron_interval = CRON_INTERVAL_DEFAULT;
	$nextjob = wp_next_scheduled('wtg_cron_post_feed_event');
	if (isset($nextjob)) {
        $cron_time = time() + $cron_interval * 60;
		wp_schedule_single_event($cron_time, 'wtg_cron_post_feed_event');
        return $cron_time;
	} else {
        false;
    }
}

function wtg_write_cron_job_script() {
	$lock_dir = 'wtg_cron_job_not_complete.lock';
	$wtg_option = get_option('wtg_option');
	if(wtg_path_is_absolute($wtg_option['feedDir'])) {
		$abs_dir = $wtg_option['feedDir'] . '/' . $lock_dir;
	} else {
		$abs_dir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/' . $lock_dir;
	}
	$url = get_option('siteurl') . '/wp-cron.php';
	$req = dirname(__FILE__) . '/process_submit.php';
	$bloginfo = get_bloginfo( 'url' );
	$blogData = parse_url($bloginfo);
	
	ob_start();
	echo '<?php' . "\n";
    ?>
	require_once ('<?php echo ABSPATH; ?>wp-load.php');
	require_once ('<?php echo ABSPATH; ?>wp-config.php');
	require_once ('<?php echo $req; ?>');
	
	if (file_exists('<?php echo $abs_dir; ?>')) {
		$u = @parse_url('<?php echo $url; ?>');
        $fp = fsockopen($u['host'], isset($u['port'])?$u['port']:80);
        if ($fp) {
            $request = "GET " . $u['path'] . (isset($u['query'])?$u['query']:'') . " HTTP/1.1\r\n";
            $request = $request . "Host: " . $u['host'] . ':' . (isset($u['port'])?$u['port']:80) . "\r\n";
            $request = $request . "Connection: Close\r\n\r\n";
            fwrite($fp, $request);
            while (!feof($fp)) {
                echo fgets($fp, 128);
            }
            fclose($fp);
        }
	}
	
	query_posts('showposts=20&post_status=future');
	if ( !have_posts() )
	{
		$wtg_option = get_option('wtg_option');
		if (isset($wtg_option['auto_queue']) && ($wtg_option['auto_queue'] == 1))
		{
			wtg_cron_submit_existing();
			
			$db = new WTG_DB();
			$jobs = $db->get_all_job();
		}
	}
	<?php
	echo '?>';
	$script = ob_get_contents();
	ob_clean();
	return $script;
}

function wtg_set_cron_job_complete($b) {
	$lock_dir = 'wtg_cron_job_not_complete.lock';
	$wtg_option = get_option('wtg_option'); // 5108
	if(wtg_path_is_absolute($wtg_option['feedDir'])) {
		$abs_dir = $wtg_option['feedDir'] . '/' . $lock_dir;
	} else {
		$abs_dir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/' . $lock_dir;
	}
	if ($b) {
		@rmdir($abs_dir);
	} else {
		@mkdir($abs_dir);
	}
}

function wtg_get_cron_job_complete() {
	$lock_dir = 'wtg_cron_job_not_complete.lock';
	$wtg_option = get_option('wtg_option');
	if(wtg_path_is_absolute($wtg_option['feedDir'])) {
		$abs_dir = $wtg_option['feedDir'] . '/' . $lock_dir;
	} else {
		$abs_dir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/' . $lock_dir;
	}
	return file_exists($abs_dir);
}